<?php
/*
 * This file is part of the Telekom PHP SDK
 * Copyright 2012 Deutsche Telekom AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	 http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Class to handle the Telekom API Username/Password authentification.
 */
class TelekomUPAuth extends TelekomAuth {
	
	/**
	 * Perform the Username/Password authentification and get the access token.
	 */
	public function requestAccessToken(){
		
		$tokenData = $this->service->getResponseTokenData($this->service->config->getApiAuthUrl());
		$this->setTokenData($tokenData);
	}
	
	/**
	 * Set the accessToken and the accessTokenValidUntil variables
	 * @param string $tokenData
	 */
	private function setTokenData($tokenData){
		
		$matchGroups = array();
		preg_match('/Expires: (.*)\R/', $tokenData, $matchGroups);
		$responseHeaderValidUntil = strtotime($matchGroups[1]);
		
		$matchGroups = array();
		preg_match('/\{.*\}/', $tokenData, $matchGroups);
		$responseArray = $this->service->transformResponseDataToArray($matchGroups[0], true);
		
		$this->setAccessToken($responseArray['token']);
		$this->setAccessTokenValidUntil($responseHeaderValidUntil);
	}
}
